/*
 * Decompiled with CFR 0.152.
 */
public class Material {
    public int id;
    public int effectCombine;
    public byte brightness;
    public boolean aBool1183;
    public int size;
    public short color;
    public TextureBlending blending;
    public byte effectId;
    public byte effectParam1;
    public int effectParam2;
    public byte shadowFactor;
    public boolean repeatT;
    public byte speedU;
    public byte speedV;
    public boolean skipTriangles;
    public boolean repeatS;
    public byte mipmapping;
    public boolean hdr;
    public boolean fliped;
    public boolean isDetailMaterial;
    public boolean textured;
    public boolean cubiod;
    public byte blendingMode;

    public Material(int id) {
        this.id = id;
    }

    public void decodeRS3(int id, Packet buffer) {
        byte speedFlag;
        buffer.readByte();
        this.size = Material.getSize(buffer.readByte() & 0xFF);
        int settings = buffer.readInt();
        this.textured = (settings & 1) != 0;
        boolean aBool2031 = (settings & 2) != 0;
        this.cubiod = (settings & 0x10) != 0;
        byte wrappingFlag = buffer.readByte();
        this.repeatS = (byte)(wrappingFlag & 7) == 1;
        this.repeatT = (byte)(wrappingFlag >> 3 & 7) == 1;
        int flag = buffer.readInt();
        if ((flag & 0x10) != 0) {
            buffer.readFloat();
            buffer.readFloat();
        }
        if (aBool2031) {
            buffer.readFloat();
        }
        if ((flag & 0x20) != 0) {
            buffer.readInt();
        }
        if ((flag & 0x40) != 0) {
            buffer.readInt();
        }
        if ((flag & 0x80) != 0) {
            buffer.readInt();
        }
        if ((flag & 0x100) != 0) {
            buffer.readInt();
        }
        if ((flag & 0x200) != 0) {
            buffer.readInt();
        }
        this.hdr = buffer.readByte() == 1;
        buffer.readByte();
        buffer.readByte();
        this.blending = TextureBlending.get(buffer.readByte());
        if (this.blending == TextureBlending.ONE) {
            this.blendingMode = buffer.readByte();
        }
        if (((speedFlag = buffer.readByte()) & 1) != 0) {
            this.speedU = buffer.readByte();
        }
        if ((speedFlag & 2) != 0) {
            this.speedV = buffer.readByte();
        }
        if (buffer.readByte() == 1) {
            this.effectId = buffer.readByte();
            this.effectParam1 = buffer.readByte();
            this.effectParam2 = buffer.readInt();
            this.effectCombine = buffer.readByte();
            buffer.readByte();
            this.mipmapping = buffer.readByte();
            this.skipTriangles = buffer.readByte() == 1;
            this.isDetailMaterial = buffer.readByte() == 1;
            this.brightness = buffer.readByte();
            this.shadowFactor = buffer.readByte();
            this.color = (short)buffer.readShort();
        }
    }

    public static int getSize(int i) {
        if (i == 0) {
            return 64;
        }
        if (i == 1) {
            return 128;
        }
        if (i == 2) {
            return 256;
        }
        if (i == 3) {
            return 512;
        }
        if (i == 4) {
            return 1024;
        }
        throw new IllegalArgumentException("Could not identify size by id:" + i);
    }
}

